#include "stdafx.h"
#include "win_demo.h"
#include "DialogPlayback.h"
#include "afxdialogex.h"
#include "sdks.h"
#include "sdks_media.h"
#include "common_struct.h"
#include "perser_json.h"
#include "pack_json.h"

int m_pb_stream_id = 0;
extern int m_handle;
extern int m_chn_option;

IMPLEMENT_DYNAMIC(CDialogPlayback, CDialogEx)

CDialogPlayback::CDialogPlayback(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_WIN_DEMO_DIALOG, pParent)
{

}

CDialogPlayback::~CDialogPlayback()
{
}

BOOL CDialogPlayback::OnInitPlayback()
{
	m_playback.InsertItem(0, TEXT("Record Policy"));
	m_playback.InsertItem(1, TEXT("Record Directory"));
	m_playback.InsertItem(2, TEXT("Record Playback"));
	m_record_policy = new CDialogRecordPolicy;
	m_record_directory = new CDialogRecordDirectory;
	m_record_playback = new CDialogRecordPlayback;
	m_record_policy->Create(IDD_DIALOG_RECORD_POLICY, &m_playback);
	m_record_directory->Create(IDD_DIALOG_RECORD_DIRECTORY, &m_playback);
	m_record_playback->Create(IDD_DIALOG_RECORD_PLAYBACK, &m_playback);
	CRect tabRect;
	m_playback.GetClientRect(&tabRect);
	tabRect.left += 1;
	tabRect.right -= 1;
	tabRect.top += 22;
	tabRect.bottom -= 1;
	m_record_policy->MoveWindow(&tabRect);
	m_record_directory->MoveWindow(&tabRect);
	m_record_playback->MoveWindow(&tabRect);
	m_record_policy->ShowWindow(SW_SHOW);
	m_record_directory->ShowWindow(SW_HIDE);
	m_record_playback->ShowWindow(SW_HIDE);
	m_record_policy->OnInitRecordPolicy();
	return TRUE;
}

void CDialogPlayback::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB_PLAYBACK, m_playback);
}


BEGIN_MESSAGE_MAP(CDialogPlayback, CDialogEx)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_PLAYBACK, &CDialogPlayback::OnTcnSelchangeTabPlayback)
	ON_WM_CLOSE()
END_MESSAGE_MAP()


void CDialogPlayback::OnTcnSelchangeTabPlayback(NMHDR *pNMHDR, LRESULT *pResult)
{
	*pResult = 0;
	switch (m_playback.GetCurSel())
	{
	case 0:
		m_record_policy->ShowWindow(SW_SHOW);
		m_record_directory->ShowWindow(SW_HIDE);
		m_record_playback->ShowWindow(SW_HIDE);
		m_record_policy->OnInitRecordPolicy();
		break;
	case 1:
		m_record_policy->ShowWindow(SW_HIDE);
		m_record_directory->ShowWindow(SW_SHOW);
		m_record_playback->ShowWindow(SW_HIDE);
		m_record_directory->OnInitRecordDirectory();
		break;
	case 2:
		m_record_policy->ShowWindow(SW_HIDE);
		m_record_directory->ShowWindow(SW_HIDE);
		m_record_playback->ShowWindow(SW_SHOW);
		m_record_playback->OnInitRecordPlayback();
		break;
	default:break;
	}
}

void CDialogPlayback::OnClose()
{
	if (m_pb_stream_id)
	{
		sdks_md_pb_stop(m_handle, m_pb_stream_id);
	}
	CDialogEx::OnClose();
}
